/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.data;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.data.ICollectionData;
import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.NBTConverter;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="crafttweaker.api.data.ListData")
@ZenRegister
@Document(value="vanilla/api/data/ListData")
public class ListData
implements ICollectionData {
    private final ListNBT internal;

    public ListData(ListNBT internal) {
        this.internal = internal;
    }

    @ZenCodeType.Constructor
    public ListData() {
        this.internal = new ListNBT();
    }

    @ZenCodeType.Constructor
    public ListData(List<IData> list) {
        this.internal = new ListNBT();
        if (list != null) {
            list.forEach(iData -> this.getInternal().add((Object)iData.getInternal()));
        }
    }

    @ZenCodeType.Constructor
    public ListData(IData ... array) {
        this(ListData.getArraySafe(array));
    }

    private static List<IData> getArraySafe(IData ... array) {
        if (array == null) {
            array = new IData[]{};
        }
        return Arrays.asList(array);
    }

    @Override
    public IData setAt(int index, IData value) {
        return NBTConverter.convert(this.getInternal().set(index, value.getInternal()));
    }

    @Override
    public void add(int index, IData value) {
        this.getInternal().add(index, value.getInternal());
    }

    @Override
    public void add(IData value) {
        this.getInternal().add((Object)value.getInternal());
    }

    @Override
    public IData remove(int index) {
        return NBTConverter.convert(this.getInternal().remove(index));
    }

    @Override
    public IData getAt(int index) {
        return NBTConverter.convert(this.getInternal().get(index));
    }

    @Override
    public int size() {
        return this.getInternal().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getInternal().isEmpty();
    }

    @Override
    public void clear() {
        this.getInternal().clear();
    }

    @Override
    public IData copy() {
        return new ListData(this.getInternal());
    }

    @Override
    public IData copyInternal() {
        return new ListData(this.getInternal().func_74737_b());
    }

    public ListNBT getInternal() {
        return this.internal;
    }

    @Override
    public List<IData> asList() {
        ArrayList<IData> data = new ArrayList<IData>();
        for (INBT inbt : this.getInternal()) {
            data.add(NBTConverter.convert(inbt));
        }
        return data;
    }

    @Override
    public boolean contains(IData data) {
        List<IData> dataValues = data.asList();
        if (dataValues != null && this.containsList(dataValues)) {
            return true;
        }
        for (INBT value : this.getInternal()) {
            if (!NBTConverter.convert(value).contains(data)) continue;
            return true;
        }
        return false;
    }

    private boolean containsList(List<IData> dataValues) {
        block0: for (IData dataValue : dataValues) {
            for (INBT value : this.getInternal()) {
                if (!NBTConverter.convert(value).contains(dataValue)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    @Override
    public String asString() {
        StringBuilder output = new StringBuilder();
        output.append('[');
        boolean first = true;
        for (INBT inbt : this.getInternal()) {
            if (first) {
                first = false;
            } else {
                output.append(", ");
            }
            output.append(NBTConverter.convert(inbt).asString());
        }
        output.append(']');
        return output.toString();
    }

    @Override
    public ITextComponent asFormattedComponent(String indentation, int indentDepth) {
        if (this.isEmpty()) {
            return new StringTextComponent("[]");
        }
        if (ListNBT.field_229695_b_.contains(this.getInternal().func_230528_d__()) && this.size() <= 8) {
            StringTextComponent component = new StringTextComponent("[");
            for (int j = 0; j < this.size(); ++j) {
                if (j != 0) {
                    component.func_240702_b_(", ");
                }
                component.func_230529_a_(this.getAt(j).asFormattedComponent("", 0));
            }
            component.func_240702_b_("]");
            return component;
        }
        StringTextComponent component = new StringTextComponent("[");
        if (!indentation.isEmpty()) {
            component.func_240702_b_("\n");
        }
        for (int i = 0; i < this.size(); ++i) {
            StringTextComponent child = new StringTextComponent(Strings.repeat((String)indentation, (int)(indentDepth + 1)));
            child.func_230529_a_(this.getAt(i).asFormattedComponent(indentation, indentDepth + 1));
            if (i != this.size() - 1) {
                child.func_240702_b_(",").func_240702_b_(indentation.isEmpty() ? " " : "\n");
            }
            component.func_230529_a_((ITextComponent)child);
        }
        if (!indentation.isEmpty()) {
            component.func_240702_b_("\n").func_240702_b_(Strings.repeat((String)indentation, (int)indentDepth));
        }
        component.func_240702_b_("]");
        return component;
    }

    @ZenCodeType.Caster(implicit=true)
    public List<IData> castToList() {
        return this.asList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListData listData = (ListData)o;
        return this.internal.equals((Object)listData.internal);
    }

    public int hashCode() {
        return this.internal.hashCode();
    }
}

